% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightmatrix.R
\name{weightmatrix}
\alias{weightmatrix}
\title{Weight matrix}
\usage{
weightmatrix(n, weight.type = "arithmetic", weight.penalty = FALSE,
                    standard.deviation = 2,
                    geometric.multiplier = 2,
                    interval.high=1, interval.low = -1,
                    custom.weights = NA,
                    plot.weights = FALSE)
}
\arguments{
\item{n}{the number of classes contained in the confusion matrix.}

\item{weight.type}{the weighting schema to be used. Can be one of:
"arithmetic" - a decreasing arithmetic progression weighting scheme,
"geometric" - a decreasing geometric progression weighting scheme,
"normal" - weights drawn from the right tail of a normal distribution,
"interval" - weights contained on a user-defined interval,
"custom" - custom weight vector defined by the user.}

\item{weight.penalty}{determines whether the weights associated with
non-diagonal elements generated by the "normal", "arithmetic" and "geometric"
weight types are positive or negative values. By default, the value is set to
FALSE, which means that generated weights will be positive values.}

\item{standard.deviation}{standard deviation of the normal distribution, if
the normal distribution weighting schema is used.}

\item{geometric.multiplier}{the multiplier used to construct the geometric
progression series, if the geometric progression weighting scheme is used.}

\item{interval.high}{the upper bound of the weight interval, if the interval
weighting scheme is used.}

\item{interval.low}{the lower bound of the weight interval, if the interval
weighting scheme is used.}

\item{custom.weights}{the vector of custom weights to be applied, is the
custom weighting scheme was selected. The vector should be equal to "n", but
can be larger, with excess values being ignored.}

\item{plot.weights}{optional setting to enable plotting of weight vector,
corresponding to the first column of the weight matrix}
}
\value{
an nxn matrix, containing the weights to be multiplied with the
  confusion matrix.
}
\description{
This function compiles a weight matrix according to one of several weighting
schemas and allows users to visualize the impact of the weight matrix on each
element of the confusion matrix.
}
\details{
The number of categories "n" should be greater or equal to 2.
}
\examples{
weightmatrix(n=4, weight.type="arithmetic", plot.weights = TRUE)
weightmatrix(n=4, weight.type="normal", standard.deviation = 1,
                  plot.weights = TRUE)
weightmatrix(n=4, weight.type="interval", interval.high = 1,
                  interval.low = -0.5, plot.weights = TRUE)
weightmatrix(n=4, weight.type="geometric", geometric.multiplier = 0.6)
weightmatrix(n=4, weight.type="custom", custom.weights = c(1,0.2,0.1,0),
                  plot.weights = TRUE)

}
\seealso{
[wconfusionmatrix()]
}
\author{
Alexandru Monahov, <https://www.alexandrumonahov.eu.org/>
}
\keyword{arithmetic}
\keyword{geometric}
\keyword{interval}
\keyword{matrix}
\keyword{normal}
\keyword{progression}
\keyword{weight}
