% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavPlot.R
\name{wavPlot}
\alias{wavPlot}
\title{Wavelet plots}
\usage{
wavPlot(Z,
               X = NULL,
               Y = NULL,
               Ylog = FALSE,
               Yrev = TRUE,
               zlim = NULL,
               coi = NULL,
               rdist = NULL,
               sig95 = NULL,
               sig05 = NULL,
               Xname = "X",
               Yname = "Y",
               Zname = "Z")
}
\arguments{
\item{Z}{A matrix with the images of the function to be plotted.}

\item{X}{A vector with x-coordinates (times).}

\item{Y}{A vector with y-coordinates (scales).}

\item{Ylog}{Logical. Considers logarithmic scale for the y-axis.}

\item{Yrev}{Logical. Considers reverse the y-axis.}

\item{zlim}{A vector of length 2 with the limits for the z-axis (the color bar).}

\item{coi}{A vector of size \code{length(X)} with the y-coordinates of the frontier of
the cone of influence.}

\item{rdist}{Numeric. Only for WSD plots, margin in the y-axis where appear border
effects.}

\item{sig95}{Logical matrix with the same size as Z. TRUE if the corresponding point in
Z is inside the significance at 95\%.}

\item{sig05}{Logical matrix with the same size as Z. TRUE if the corresponding point in
Z is inside the significance at 5\%.}

\item{Xname}{A string with the name of the x-axis.}

\item{Yname}{A string with the name of the y-axis.}

\item{Zname}{A string with the name of the function.}
}
\description{
This function plots a function of two variables (usually times and
scales). It is suitable for plotting windowed scalograms, windowed scalogram
differences, wavelet coherences and windowed scale indices.
}
\examples{

nt <- 1500
time <- 1:nt
sd_noise <-  0.2 #\% In BolÃ³s et al. 2017 Figure 1, sd_noise = 1.
signal1 <- rnorm(n = nt, mean = 0, sd = sd_noise) + sin(time / 10)
signal2 <- rnorm(n = nt, mean = 0, sd = sd_noise) + sin(time / 10)
signal2[500:1000] = signal2[500:1000] + sin((500:1000) / 2)
\dontrun{
wsd <- wsd(signal1 = signal1, signal2 = signal2, mc_nrand = 10, makefigure = FALSE)
wavPlot(Z = -log2(wsd$wsd), X = wsd$t, Y = wsd$scales, Ylog = TRUE, coi = wsd$coi,
        rdist = wsd$rdist, sig95 = wsd$signif95, sig05 = wsd$signif05, Xname = "Time",
        Yname = "Scale", Zname = "-log2(WSD)")
}

}
