% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dd_heuristic.r
\name{dd_heuristic}
\alias{dd_heuristic}
\title{Semi-Optimal Heuristic for the Picker’s Route Designation}
\usage{
dd_heuristic(coordinates, arcs = NULL)
}
\arguments{
\item{coordinates}{A data frame or matrix with columns `x` and `y` representing the coordinates of warehouse locations.}

\item{arcs}{A matrix representing the initial arcs in the warehouse graph. If `NULL`, the arcs will be generated using the `create_arcs` function.}
}
\value{
A matrix representing the optimized warehouse graph, including the routing paths and IO points.
}
\description{
This function applies a semi-optimal heuristic for warehouse routing problems by optimizing aisle configurations and creating a feasible tour graph.
}
\details{
The heuristic optimizes aisle usage by identifying empty aisles and minimizing the loss associated with routing through the warehouse. It performs the following steps:
\itemize{
  \item Calculates the warehouse height and width based on coordinates.
  \item Identifies and isolates empty aisles.
  \item Evaluates configurations using a binary vector approach and selects the configuration with the minimum routing loss.
  \item Adjusts arcs to create a semi-optimal tour graph.
}

The algorithm returns an optimized graph that balances routing efficiency and warehouse constraints.
}
\examples{
coordinates <- matrix(c(1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5,
                       0, 4, 11, 0, 10, 11, 0, 1, 5, 11, 0, 4, 11, 0, 4,
                       11), ncol = 2, byrow = FALSE,
                       dimnames = list(NULL, c("x", "y")))
dd_heuristic(coordinates)


}
\references{
Dmytrów, K. (2022). Analytical and simulation determination of order picking time in a low storage warehouse for shared storage systems. Operations Research and Decisions, 32(2), 34–51. \doi{10.37190/ord220203}

Le-Duc, T. (2005). Design and Control of Efficient Order. Erasmus Research Institute of Management (ERIM).

Tarczyński, G. (2012). Analysis of the Impact of Storage Parameters and the Size of Orders on the Choice of the Method for Routing Order Picking. Operations Research and Decisions, 22(4), 105–120. \doi{10.5277/ord120406}
}
\seealso{
\code{\link{midpoint_heuristic}}, \code{\link{return_heuristic}}, \code{\link{sshape_heuristic}}
}
\author{
Krzysztof Dmytrów \email{krzysztof.dmytrow@usz.edu.pl} [aut] \href{https://orcid.org/0000-0001-7657-6063}{ORCID: 0000-0001-7657-6063}

Andrzej Dudek \email{andrzej.dudek@ue.wroc.pl} [aut, cre] \href{https://orcid.org/0000-0002-4943-8703}{ORCID: 0000-0002-4943-8703}
}
