% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_table.R
\name{is_extended_selection_table}
\alias{is_extended_selection_table}
\title{Class 'extended_selection_table': selection table containing wave objects}
\usage{
is_extended_selection_table(x)
}
\arguments{
\item{x}{R object}
}
\value{
A logical argument indicating whether the object class is 'extended_selection_table'
}
\description{
Class for selections of signals in sound files and corresponding wave objects
}
\details{
An object of class \code{extended_selection_table} created by \code{\link{selection_table}} is a list with the following elements:
 \itemize{
 \item \code{selections}: data frame containing the frequency/time coordinates of the selections, sound file names, and any  additional information
 \item \code{check.resutls}: results of the checks on data consistency using \link{checksels}
 \item \code{wave.objects}: list of wave objects corresponding to each selection
 \item \code{by.song}: a list with 1) a logical argument defining if the 'extended_selection_table' was created 'by song'
 and 2) the name of the song column (see \code{\link{selection_table}})
 }
}
\examples{
{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))

is_extended_selection_table(lbh_selec_table)

writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

st <- selection_table(lbh_selec_table, extended = TRUE, confirm.extended = FALSE, path = tempdir())

is_extended_selection_table(st)

class(st)
}
}
\seealso{
\code{\link{selection_table}}, \code{\link{selection_table}}
Check if object is of class "extended_selection_table"

\code{is_extended_selection_table} Check if the object belongs to the class "extended_selection_table"

\code{\link{selection_table}}; \code{\link{is_selection_table}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
