% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predict.R
\name{plot_predict}
\alias{plot_predict}
\title{Prediction intervals for walker object}
\usage{
plot_predict(object, level = 0.05, alpha = 0.33)
}
\arguments{
\item{object}{An output from \code{\link{predict.walker_fit}}.}

\item{level}{Level for intervals. Default is 0.05, leading to 90\% intervals.}

\item{alpha}{Transparency level for \code{\link{geom_ribbon}}.}
}
\description{
Plots sample quantiles and posterior means of the predictions 
of the \code{predict.walker_fit} output.
}
\examples{
set.seed(1)
n <- 60
slope <- 0.0001 + cumsum(rnorm(n, 0, sd = 0.01))
beta <- numeric(n)
beta[1] <- 1
for(i in 2:n) beta[i] <- beta[i-1] + slope[i-1]
ts.plot(beta)                
x <- rnorm(n, 1, 0.5)
alpha <- 2
ts.plot(beta * x)

signal <- alpha + beta * x
y <- rnorm(n, signal, 0.25)
ts.plot(cbind(signal, y), col = 1:2)
data_old <- data.frame(y = y[1:(n-10)], x = x[1:(n-10)])
rw2_fit <- walker(y ~ 1 + 
                    rw2(~ -1 + x,
                        beta = c(0, 10), 
                        sigma = c(0, 10), 
                        nu = c(0, 10)), 
                  sigma_y = c(0, 10), 
                  beta = c(0, 10),
                  iter = 400, chains = 1, data = data_old)

pred <- predict(rw2_fit, newdata = data.frame(x=x[(n-9):n]))
data_new <- data.frame(t = (n-9):n, y = y[(n-9):n])
plot_predict(pred) + 
  geom_line(data=data_new, aes(t, y), linetype="dashed", colour = "red", inherit.aes = FALSE)

}
