% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorem_ipsum.R
\name{lorem_ipsum}
\alias{lorem_ipsum}
\alias{paragraph}
\title{Generate Random Lorem Ipsum Strings}
\usage{
lorem_ipsum(n, ..., name = "Lorem_Ipsum")

paragraph(n, ..., name = "Paragraph")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}

\item{\dots}{Other arguments passed to  \code{\link[stringi]{stri_rand_lipsum}}.}
}
\value{
Returns a random character vector of string elements.
}
\description{
Generates (pseudo)random \href{http://www.lipsum.com/}{\emph{lorem ipsum}}
text.
}
\note{
\code{lorem_ipsum} and \code{paragraph} produce identical strings but
will produce different vector/column names when used inside of
\code{r_data_frame} or \code{r_list}.
}
\examples{
lorem_ipsum(10)
paragraph(10)

lorem_ipsum(10, start_lipsum = FALSE)
}
\seealso{
\code{\link[stringi]{stri_rand_lipsum}}

Other variable.functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{hair}},
  \code{\link{height}}, \code{\link{income}},
  \code{\link{internet_browser}}, \code{\link{iq}},
  \code{\link{language}}, \code{\link{level}},
  \code{\link{likert}}, \code{\link{marital}},
  \code{\link{military}}, \code{\link{month}},
  \code{\link{name}}, \code{\link{normal}},
  \code{\link{political}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{character}
\keyword{string}

