% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/income.R
\name{income}
\alias{income}
\title{Generate Random Gamma Vector of Incomes}
\usage{
income(n, digits = 2, name = "Income")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{digits}{Integer indicating the number of decimal places to be used.
Negative values are allowed (see \code{\link[base]{round}}).}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random gamma vector of income elements.
}
\description{
Generate a random gamma vector of incomes.
}
\details{
Incomes are generated using: \code{rgamma(n, 2) * 2000}.
}
\examples{
income(10)
hist(income(10000))
pie(table(cut(income(10000), 10)))
}
\seealso{
\code{\link[base]{gamma}}

Other variable.functions: \code{\link{age}};
  \code{\link{animal}}, \code{\link{pet}};
  \code{\link{answer}}; \code{\link{area}};
  \code{\link{birth}}, \code{\link{dob}};
  \code{\link{car}}; \code{\link{children}};
  \code{\link{coin}}; \code{\link{color}},
  \code{\link{primary}}; \code{\link{date_stamp}};
  \code{\link{death}}, \code{\link{died}};
  \code{\link{dice}}; \code{\link{dna}};
  \code{\link{dummy}}; \code{\link{education}};
  \code{\link{ela}}, \code{\link{level}},
  \code{\link{math}}; \code{\link{employment}};
  \code{\link{eye}}; \code{\link{gender_inclusive}},
  \code{\link{sex_inclusive}}; \code{\link{gender}},
  \code{\link{sex}}; \code{\link{gpa}},
  \code{\link{grade}}, \code{\link{grade_letter}};
  \code{\link{grade_level}}; \code{\link{group}};
  \code{\link{hair}}; \code{\link{height}},
  \code{\link{height_cm}}, \code{\link{height_in}};
  \code{\link{internet_browser}}; \code{\link{iq}};
  \code{\link{language}}; \code{\link{likert}},
  \code{\link{likert_5}}, \code{\link{likert_7}};
  \code{\link{lorem_ipsum}}, \code{\link{paragraph}};
  \code{\link{lower}}, \code{\link{lower_factor}},
  \code{\link{upper}}, \code{\link{upper_factor}};
  \code{\link{marital}}; \code{\link{military}};
  \code{\link{month}}; \code{\link{name}};
  \code{\link{normal}}, \code{\link{normal_round}};
  \code{\link{political}}; \code{\link{race}};
  \code{\link{religion}}; \code{\link{sat}};
  \code{\link{sentence}}; \code{\link{smokes}};
  \code{\link{speed}}, \code{\link{speed_kph}},
  \code{\link{speed_mph}}; \code{\link{state}};
  \code{\link{string}}; \code{\link{valid}};
  \code{\link{year}}; \code{\link{zip_code}}
}
\keyword{income}

