% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/waffle-package.R, R/waffle.R
\docType{package}
\name{waffle}
\alias{waffle}
\alias{waffle-package}
\title{A package to make waffle charts (square pie charts) in R.}
\usage{
waffle(parts, rows = 10, xlab = NULL, title = NULL, colors = NA,
  size = 2, flip = FALSE, reverse = FALSE, equal = TRUE, pad = 0)
}
\arguments{
\item{parts}{named vector of values to use for the chart}

\item{rows}{number of rows of blocks}

\item{xlab}{text for below the chart. Highly suggested this be used to
give the "1 sq == xyz" relationship if it's not obvious}

\item{title}{chart title}

\item{colors}{exactly the number of colors as values in \code{parts}.
If omitted, Color Brewer "Set2" colors are used.}

\item{size}{width of the separator between blocks (defaults to \code{2})}

\item{flip}{flips x & y axes}

\item{reverse}{reverses the order of the data}

\item{equal}{by default, waffle uses \code{coord_equal}; this can cause
layout problems, so you an use this to disable it if you are using
ggsave or knitr to control output sizes (or manually sizing the chart)}

\item{pad}{how many blocks to right-pad the grid with}
}
\description{
A package to make waffle charts (square pie charts) in R.

Given a named vector, this function will return a ggplot object that
represents a waffle chart of the values. The individual values will be
summed up and each that will be the total number of squares in the grid.
You can perform appropriate value transformation ahead of time to get the
desired waffle layout/effect.
}
\details{
If the vector is not named or only partially named, capital letters will be
used instead. It is highly suggested that you limit the number of elements
to plot, just like you should if you ever got wasted and decided that a
regular pie chart was a good thing to create and then decide to be totally
evil and make one to pollute this beautiful world of ours.

Chart title and x-axis labels are optional, especially if you'll just be
exporting to another program for use/display.
}
\examples{
parts <- c(80, 30, 20, 10)
chart <- waffle(parts, rows=8)
# print(chart)

parts <- c(One=80, Two=30, Three=20, Four=10)
chart <- waffle(parts, rows=8)
# print(chart)
}

