% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_logical_named.R
\name{assert_logical_named}
\alias{assert_logical_named}
\title{Assert Logical Value in Column}
\usage{
assert_logical_named(column, df, prefix_column = NULL, ...)
}
\arguments{
\item{column}{A character vector or string with the column name to be tested.}

\item{df}{The data frame that contains the column.}

\item{prefix_column}{A character string that will be prepended to the column name in the assertion message. Default is NULL.}

\item{...}{Additional parameters are passed to the \code{checkmate::assert_logical} function.}
}
\value{
None
}
\description{
This function asserts that the values in a specified column of a data frame are logical.
It uses the \code{checkmate::assert_logical} function to perform the assertion.
}
\examples{
# Create a data frame
df <- data.frame(a = c(TRUE, FALSE, TRUE, FALSE), b = c(1, 2, 3, 4))
# Assert that the values in column "a" are logical
assert_logical_named("a", df)

}
