% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{bind_varimax_z}
\alias{bind_varimax_z}
\alias{bind_varimax_y}
\alias{bind_svd_u}
\alias{bind_svd_v}
\title{Add Z factor loadings to node table of tidygraph}
\usage{
bind_varimax_z(graph, fa, ...)

bind_varimax_y(graph, fa, ...)

bind_svd_u(graph, fa, ...)

bind_svd_v(graph, fa, ...)
}
\arguments{
\item{graph}{A \link[tidygraph:tbl_graph]{tidygraph::tbl_graph} object.}

\item{fa}{Optionally, a \link{vsp} object to extract varimax loadings from. If
you do not passed a \link{vsp} object, one will be created.}

\item{...}{
  Arguments passed on to \code{\link[=vsp]{vsp}}
  \describe{
    \item{\code{x}}{Either a graph adjacency matrix, \link[igraph:aaa-igraph-package]{igraph::igraph} or
\link[tidygraph:tbl_graph]{tidygraph::tbl_graph}. If \code{x} is a \link{matrix} or \link[Matrix:Matrix]{Matrix::Matrix}
then \code{x[i, j]} should correspond to the edge going from node \code{i}
to node \code{j}.}
    \item{\code{rank}}{The number of factors to calculate.}
  }}
}
\value{
The same \code{graph} object with columns \code{factor1}, ..., \verb{factor\{rank\}}
in the table of node information.
}
\description{
Add Z factor loadings to node table of tidygraph
}
\section{Functions}{
\itemize{
\item \code{bind_varimax_y}: Add Y factor loadings to node table of tidygraph

\item \code{bind_svd_u}: Add left singular vectors to node table of tidygraph

\item \code{bind_svd_v}: Add right singular vectors to node table of tidygraph
}}

