% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parMap.R
\name{parMap}
\alias{parMap}
\title{Create parametric maps}
\usage{
parMap(parameters, mask, method = "none", outDir = NULL)
}
\arguments{
\item{parameters}{list of parametric and smooth table coefficients or ANOVA (like the output from vlmParam, vgamParam, anovalmVoxel)}

\item{mask}{Input mask of type 'nifti' or path to one. Must be a binary mask or a character. Must match the mask passed to one of vlmParam, vgamParam, vgamm4Param, vlmerParam}

\item{method}{which method of correction for multiple comparisons (default is none)}

\item{outDir}{Path to the folder where to output parametric maps (Default is Null, only change if you want to write maps out)}
}
\value{
Return parametric maps of the fitted models
}
\description{
This function create parametric maps according from model parametric tables or analysis of variance tables. 
The function will return a p-map, t-map, signed z-map, p-adjusted-map for parametric terms and p-map, z-map, p-adjusted-map for smooth terms. 
Additionally the function will return a p-map, F-map, p-to-z-map, and p-adjusted-map if the input is ANOVA.
You can select which type of p-value correction you want done on the map. The z-maps are signed just like FSL.
}
\examples{
image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(0:1, dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), y = runif(25))
fm1 <- "~ x + y"
models <- vlmParam(image=image, mask=mask, 
              formula=fm1, subjData=covs, ncores = 1)
Maps <- parMap(models, mask, method="fdr")
}
