% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammNIfTI.R
\name{gammNIfTI}
\alias{gammNIfTI}
\title{Wrapper to run a Generalized Additive Mixed Effects model on an Nifti and output a parametric map}
\usage{
gammNIfTI(image, mask, fourdOut = NULL, formula, randomFormula, subjData,
  mc.preschedule = TRUE, ncores = 1, method = "none", residual = FALSE,
  outDir = NULL, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. Must be a binary mask}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to gamm4()}

\item{randomFormula}{Random effects formula passed to gamm4()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{method}{which method of correction for multiple comparisons (default is none)}

\item{residual}{If set to TRUE then residuals maps will be returned along parametric maps}

\item{outDir}{Path to the folder where to output parametric maps (Default is Null, only change if you want to write maps out)}

\item{...}{Additional arguments passed to gamm4()}
}
\value{
Returns Parametric maps of the fitted models over the NIfTI image
}
\description{
This function is able to run a Generalized Additive Model (GAMM) using the gamm4() function. 
The analysis will run in all voxels within the mask and will return parametric and smooth coefficients. 
The function will create parametric maps according to the model selected. 
The function will return a p-map, t-map, z-map, p-adjusted-map for parametric terms and p-map, z-map, p-adjusted-map for smooth terms.
You can select which type of p-value correction you want done on the map
}
\examples{

image <- oro.nifti::nifti(img = array(rnorm(1600, sd=10), dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(c(rep(0,14), rep(1,2)), dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), y = runif(25), id = rep(1:5,5))
fm1 <- "~ s(x) + s(y)"
randomFormula <- "~(1|id)"
Maps <- gammNIfTI(image, mask, formula = fm1, 
                 randomFormula = randomFormula, subjData = covs, ncores = 1,
                 method="fdr", REML=TRUE)


}
