% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.fd.R
\name{extract.fd}
\alias{extract.fd}
\title{Extract curve estimates to be clustered}
\usage{
extract.fd(obj, term = 1, intercept = (term == 1))
}
\arguments{
\item{obj}{object created by \code{\link{semipar.mp}}.}

\item{term}{which smooth term to extract (useful if the fitted model includes more than one term).}

\item{intercept}{logical; if \code{TRUE}, intercept will be added to all coefficients. For simple nonparametric regression
this should be done to recover the fitted values.}
}
\value{
an object of class \code{"\link{fd}"} representing the fitted curves, which can be clustered by 
\code{\link{funkmeans}}.
}
\description{
Given a massively parallel smoothing object created by \code{\link{semipar.mp}}, this function extracts an object of
class \code{"\link{fd}"} representing the curves that one wishes to cluster using \code{\link{funkmeans}}.
}
\examples{
# see example for plot.funkmeans
}
\author{
Ruixin Tan
}
\seealso{
\code{\link{semipar.mp}}, \code{\link{funkmeans}}
}

