% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate_dirichlet}
\alias{generate_dirichlet}
\title{Generate multinomial scores}
\usage{
generate_dirichlet(n_candidates, n_voters, probs = 0)
}
\arguments{
\item{n_candidates}{integer,  The number of candidates to generate scores for.}

\item{n_voters}{integer, the number of voters to generate scores for.}

\item{probs}{A vector of size n_candidates corresponding to the parameters of the Dirichlet distribution. By default all values are equal to 1.}
}
\value{
A matrix of scores with 'n_candidates' rows and 'n_voters' columns.
}
\description{
This function generates  scores following a Dirichlet distribution
}
\examples{
voting_situation <- generate_dirichlet(n_voters=10, n_candidates=3,  probs=c(0.5, 0.3, 0.2))
}
