% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.activity.web.R
\name{Create.activity.web}
\alias{Create.activity.web}
\title{Create web activity network}
\usage{
\method{Create}{activity.web}(datasource, type, lcase = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"web"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"activity"}.}

\item{lcase}{Logical. Convert urls and page names to lowercase.}

\item{verbose}{Logical. Output additional information about the network creation. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a web page activity network from pages. Nodes are web pages.
}
\examples{
\dontrun{
# create a web activity network graph
net_activity <- data_collect |> Create("activity")

# network
# net_activity$nodes
# net_activity$edges
}

}
