% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vortexR_pkg_data.R
\docType{package}
\name{vortexR}
\alias{vortexR}
\title{vortexR: an R package for Post Vortex Simulation Analysis}
\description{
\code{vortexR} facilitates Post Vortex Simulation Analysis (PVSA) by offering
tools to collate multiple Vortex (v10) output files into one R object, generate
plots and conduct basic analysis (e.g. pairwise comparisons of scenarios) and
more advanced statistics such as fitting of a Generalised Linear Model (GLM)
to investigate the main and the interaction effects of the variables of
interest.
}
\details{
\code{vortexR} has a number of functions that are useful during the
development of a Vortex project and for its analysis after completion.
\code{vortexR} makes it easy to automatise the creation of plots and
computation of basic statistics to inspect the effect of changes carried out
in the Vortex project. Once the project development is completed, the same
framework used in \code{vortexR} during the development of the project can be
refined and extended to include more advanced statistical analyses or can be
easily included in Markdown documents for the creation of reports (by
converting them into pdf) or update web-pages.

The use of \code{vortexR} ensures reproducibility and standardises analytical
approaches in population viability analysis.
}
\section{Documentations}{

Use \code{help(package = 'vortexR')} for a list of \code{vortexR} functions
and their specific documentations.

A more detailed description of the package and functions can be opened with:
\code{vignette(package='vortexR', topic='User-guide')}.

More vignettes may be come available in the future. Use
\code{vignette(package='vortexR')} to see all the available vignettes.
}

\section{Citation}{

If you use \code{vortexR}, please cite:
Pacioni, C., and Mayer, F. (2017). vortexR: an R package for post Vortex
simulation analysis. Methods in Ecology and Evolution.
}

\section{Get in touch}{

Please, use \url{https://github.com/carlopacioni/vortexR/issues} to report
any issues with vortexR. If unsure, or for feedback, contact me at:
carlo.pacioni 'at' gmail.com.
}

\section{Publications}{

\emph{Below there are listed a few publications that used \code{vortexR}.}

Campbell et al. (2016). Assessing the economic benefits of starling
 detection and control to Western Australia. Australasian Journal of
 Environmental Management, 23, 81-99.
 \href{https://dx.doi.org/10.1080/14486563.2015.1028486}{DOI:10.1080/14486563.2015.1028486}

Pacioni, C., Williams, M., Lacy RC, Spencer, P.B.S. and Wayne, A.F. (2017)
 Predators and genetic fitness: key threatening factors for the conservation
 of bettong species. Pacific Conservation Biology.
 \href{https://doi.org/10.1071/PC17002}{DOI:10.1071/PC17002}
}

