% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plotting.R
\name{line_plot_year}
\alias{line_plot_year}
\title{Line plots of Vortex parameters vs years}
\usage{
line_plot_year(data, project, scenario, params = c("PExtinct", "Nextant",
  "Het", "Nalleles"), plotpops = c("all"), save2disk = TRUE,
  dir_out = "Plots")
}
\arguments{
\item{data}{A df from \code{collate_dat}}

\item{project}{Vortex project name (used to name the output)}

\item{scenario}{Vortex scenario name (used to name the output)}

\item{params}{Vortex parameters to be plotted,
default: c('PExtinct', 'Nextant', 'Het', 'Nalleles')}

\item{plotpops}{The populations to be included in the plot, default: 'all'}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: Plots}
}
\value{
Line plot(s)
}
\description{
\code{line_plot_year} generates line plots of the selected Vortex parameters
for the selected populations, for all simulated years.
}
\details{
Plots are ggplot objects. When \code{save2disk=TRUE} these are saved as .rda
and .pdf files
}
\examples{
# Using Pacioni et al. example data. See ?pac.clas for more details.
data(pac.clas)
lineplot.st.classic <- line_plot_year(data=pac.clas, project='Pacioni_et_al',
                       scenario='ST_Classic',
                       params=c('PExtinct', 'Nextant', 'Het', 'Nalleles'),
                       save2disk=FALSE)
}
