% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{collate_run}
\alias{collate_run}
\title{Collate Vortex .run output files}
\usage{
collate_run(project, scenario, npops = 1, dir_in = NULL, save2disk = TRUE,
  dir_out = "ProcessedData", verbose = TRUE)
}
\arguments{
\item{project}{The Vortex project name to be imported}

\item{scenario}{The scenario name}

\item{npops}{The total number of simulated populations including the
metapopulation}

\item{dir_in}{The local folder containing Vortex files, default: NULL. If
not specified, will fall back to use current working directory.}

\item{save2disk}{Whether to save the data as rda and csv, default: TRUE}

\item{dir_out}{The local path to store the output. Default: ProcessedData}

\item{verbose}{Progress messages, default: TRUE}
}
\value{
a list with two elements: run, a data.frame with data from all
  Vortex files and lrun, where the same data are re-arranged in long format
}
\description{
\code{collate_run} collates all Vortex output files with extension .run
matching the project and scenario name in a given directory  into one  named
list.
}
\details{
\code{dir_in} may contain other files; only files matching the project and
the scenario name will be read.

\code{dir_out} is created within the working directory unless a full path is
provided.

If no matching files are found in the given directory, an error is reported.

When \code{verbose=TRUE} the progress (i.e. the file being read) is reported
on screen.
}
\examples{
# Using Pacioni et al. example files. See ?pacioni for more details.
pac.dir <- system.file('extdata', 'pacioni', package='vortexRdata')
# Run collate_run on all .run of the project 'Pacioni_et_al' and
run <- collate_run('Pacioni_et_al', 'ST_LHS', 1, dir_in=pac.dir,
                   save2disk=FALSE)
}
