% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputProcessingUtilties.R
\name{columnParse}
\alias{columnParse}
\title{Column Parsing}
\usage{
columnParse(occs, wDepth = FALSE)
}
\arguments{
\item{occs}{A \code{data.frame} with at least two columns
named "longitude" and "latitude" or that
can be coerced into this format.}

\item{wDepth}{Logical; flags whether a depth column should
also be sought.}
}
\value{
A \code{list} of length 2 with indices of the x and y
columns, respectively, followed by a message with a plain
text report of which columns were interpreted as x and y.
}
\description{
Parses column names from input occurrence
\code{data.frame} for more seamless function
}
\details{
This is an internal function to return the putative
indices for latitude and longitude or x and y coordinates
of occurrences to allow for code that is more robust to
very common user error
}
\examples{
library(terra)

# Create sample raster
r <- rast(ncol=10, nrow=10)
values(r) <- 1:100

# Create test occurrences
set.seed(0)
longitude <- sample(ext(r)[1]:ext(r)[2],
                    size = 10, replace = FALSE)
set.seed(0)
latitude <- sample(ext(r)[3]:ext(r)[4],
                   size = 10, replace = FALSE)
set.seed(0)
depth <- sample(0:35, size = 10, replace = TRUE)
occurrences <- as.data.frame(cbind(longitude,latitude,depth))

# Here's the function
result <- columnParse(occs = occurrences[,1:2],
                      wDepth = FALSE)
result <- columnParse(occs = occurrences,
                      wDepth = TRUE)

}
\keyword{internal}
