% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_metrics_one_grouped}
\alias{effect_metrics_one_grouped}
\title{Output a regression table with estimates and macro statistics}
\usage{
effect_metrics_one_grouped(
  data,
  col,
  cross,
  method = "lm",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding metric values.}

\item{cross}{The column holding groups to compare.}

\item{method}{A character vector of methods, e.g. c("t.test","lm").
Supported methods are t.test (only valid if the cross column contains two levels)
and lm (regression results).}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker list object containing volker tables with the requested statistics.

Regression table:
\itemize{
\item \strong{estimate}: Regression coefficient (unstandardized).
\item \strong{ci low / ci high}: lower and upper bound of the 95\% confidence interval.
\item \strong{se}: Standard error of the estimate.
\item \strong{t}: t-statistic.
\item \strong{p}: p-value for the statistical test.
\item \strong{stars}: Significance stars based on p-value (*, **, ***).
}

Macro statistics:
\itemize{
\item \strong{Adjusted R-squared}: Adjusted coefficient of determination.
\item \strong{F}: F-statistic for the overall significance of the model.
\item \strong{df}: Degrees of freedom for the model.
\item \strong{residual df}: Residual degrees of freedom.
\item \strong{p}: p-value for the statistical test.
\item \strong{stars}: Significance stars based on p-value (*, **, ***).
}

If \code{method = t.test}:
\subsection{Shapiro-Wilk test (normality check):}{
\itemize{
\item \strong{W}: W-statistic from the Shapiro-Wilk normality test.
\item \strong{p}: p-value for the test.
\item \strong{normality}: Interpretation of the Shapiro-Wilk test.
}
}

\subsection{Levene test (equality of variances):}{
\itemize{
\item \strong{F}: F-statistic from the Levene test for equality of variances between groups.
\item \strong{p}: p-value for Levene's test.
\item \strong{variances}: Interpretation of the Levene test.
}
}

\subsection{Cohen's d (effect size):}{
\itemize{
\item \strong{d}: Standardized mean difference between the two groups.
\item \strong{ci low / ci high}: Lower and upper bounds of the 95\% confidence interval.
}
}

\subsection{t-test}{
\itemize{
\item \strong{method}: Type of t-test performed (e.g., "Two Sample t-test").
\item \strong{difference}: Observed difference between group means.
\item \strong{ci low / ci high}: Lower and upper bounds of the 95\% confidence interval.
\item \strong{se}: Estimated standard error of the difference.
\item \strong{df}: Degrees of freedom used in the t-test.
\item \strong{t}: t-statistic.
\item \strong{p}: p-value for the t-test.
\item \strong{stars}: Significance stars based on p-value (\code{*}, \verb{**}, \verb{***}).
}
}
}
\description{
The regression output comes from \code{stats::\link[stats:lm]{lm}}.
T-test is performed using \code{stats::\link[stats:t.test]{t.test}}.
Normality check is performed using
\code{stats::\link[stats:shapiro.test]{shapiro.test}}.
Equality of variances across groups is assessed using \code{car::\link[car:leveneTest]{leveneTest}}.
Cohen's d is calculated using \code{effectsize::\link[effectsize:cohens_d]{cohens_d}}.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_metrics_one_grouped(data, sd_age, sd_gender)

}
\keyword{internal}
