% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HpolytopeClass.R
\docType{class}
\name{Hpolytope-class}
\alias{Hpolytope-class}
\alias{Hpolytope}
\title{An R class to represent an H-polytope}
\description{
An H-polytope is a convex polytope defined by a set of linear inequalities or equivalently a \eqn{d}-dimensional H-polytope with \eqn{m} facets is defined by a \eqn{m\times d} matrix A and a \eqn{m}-dimensional vector b, s.t.: \eqn{Ax\leq b}.
}
\details{
\describe{
   \item{A}{An \eqn{m\times d} numerical matrix.}

   \item{b}{An \eqn{m}-dimensional vector b.}

   \item{volume}{The volume of the polytope if it is known, \eqn{NaN} otherwise by default.}
   
   \item{type}{A character with default value 'Hpolytope', to declare the representation of the polytope.}
}
}
\examples{
A = matrix(c(-1,0,0,-1,1,1), ncol=2, nrow=3, byrow=TRUE)
b = c(0,0,1)
P = Hpolytope(A = A, b = b)
 
}
