% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_beta_crit.R
\name{racusum_beta_crit}
\alias{racusum_beta_crit}
\alias{racusum_beta_crit_mc}
\alias{racusum_beta_crit_sim}
\title{Alarm thresholds of Beta RA-CUSUM charts}
\usage{
racusum_beta_crit_mc(L0, shape1, shape2, g0, g1, RA, RQ = 1, method = 1,
  r = 600, jmax = 4, verbose = TRUE)

racusum_beta_crit_sim(L0, shape1, shape2, g0, g1, RA = 2, RQ = 1, nc = 1,
  rs = 71, hmax = 30, jmax = 4, m = 10000, verbose = FALSE)
}
\arguments{
\item{L0}{Double. Prespecified Average Run Length.}

\item{shape1}{Double. Shape parameter \eqn{\alpha}{alpha} \code{> 0} of the beta distribution.}

\item{shape2}{Double. Shape parameter \eqn{\beta}{beta} \code{> 0} of the beta distribution.}

\item{g0}{Double. Estimated intercept coefficient from a binary logistic regression model.}

\item{g1}{Double. Estimated slope coefficient from a binary logistic regression model.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}. Odds ratio of death under the null hypotheses is \code{1}.}

\item{RQ}{Double. Defines the true performance of a surgeon with the odds ratio ratio of death
\code{RQ}. Use \code{RQ = 1} to compute the in-control ARL and other values to compute the
out-of-control ARL.}

\item{method}{Character. If \code{method = "1"} a combination of Sequential Probability Ratio
Test and Toeplitz matrix structure is used to calculate the ARL. \code{"2"} solves a linear
equation system using the classical approach of \emph{Brook and Evans (1972)} to calculate the
ARL.}

\item{r}{Double. Matrix system dimension.}

\item{jmax}{Integer. Number of digits for grid search.}

\item{verbose}{Logical. If \code{FALSE} a quiet calculation of \code{h} is done. If \code{TRUE}
verbose output of the search procedure (see details) is included.}

\item{nc}{Integer. Number of cores used for parallel processing. Value is passed to
\code{\link{parSapply}}.}

\item{rs}{Integer. Maximum risk score.}

\item{hmax}{Integer. Maximum value of \code{h} for the grid search.}

\item{m}{Integer. Number of simulation runs.}
}
\value{
Returns a single value which is the control limit \code{h} for a given In-control ARL.
}
\description{
Compute alarm threshold of risk-adjusted CUSUM charts assuming a beta distributed
patient mix.
}
\details{
Determines the control limit ("\code{h}") for a given in-control ARL (\code{"L0"}) using
\code{\link{racusum_beta_arl_mc}} or \code{\link{racusum_beta_arl_sim}} and
\code{\link{parSapply}} by applying a grid search.
}
\examples{
\dontrun{
library(vlad)
## Markov Chain
racusum_beta_crit_mc(L0=7500, shape1=.61, shape2=4.09, g0=-3.6798, g1=0.0768*71, RA=2, RQ=1,
 r=1e3)
## Monte Carlo simulation
racusum_beta_crit_sim(L0=7500, shape1=.61, shape2=4.09, g0=-3.6798, g1=0.0768, RA = 2, RQ = 1,
rs = 71, verbose=TRUE, m=1e3)
}
}
\references{
Brook D and Evans DA (1972)
 An approach to the probability distribution of CUSUM run length.
 \emph{Biometrika}, \strong{59}(3), pp. 539--549
}
