% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{racusum_ad_sim}
\alias{racusum_ad_sim}
\title{Compute steady-state ARLs of RA-CUSUM control charts using
simulation}
\usage{
racusum_ad_sim(r, pmix, h, RA = 2, RQ = 1, m = 50, type = "cond")
}
\arguments{
\item{r}{Integer Vector. Number of runs.}

\item{pmix}{Data Frame. A three column data frame. First column is the operation outcome.
Second column are the predicted probabilities from the risk model. Third column can be either the
 predicted probabilities from the risk model or average outcome.}

\item{h}{Double. Control Chart limit for detecting deterioration/improvement.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}. Odds ratio of death under the null hypotheses is \code{1}.}

\item{RQ}{Double. Defines the true performance of a surgeon with the odds ratio ratio of death
\code{RQ}. Use \code{RQ = 1} to compute the in-control ARL and other values to compute the
out-of-control ARL.}

\item{m}{Integer. Simulated in-control observations.}

\item{type}{Character. Default argument is \code{"cond"} for computation of conditional
steady-state. Other option is the cyclical steady-state \code{"cycl"}.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Compute steady-state ARLs of risk-adjusted cumulative sum control charts using
 simulation.
}
\author{
Philipp Wittenberg
}
