% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zPath.R
\name{zPath}
\alias{zPath}
\title{zPath}
\usage{
zPath(
  viv,
  cutoff = NULL,
  method = c("greedy.weighted", "strictly.weighted"),
  connect = TRUE
)
}
\arguments{
\item{viv}{A matrix, created by \code{vivi} to be used to calculate the path.}

\item{cutoff}{Do not include any variables that are below the cutoff interaction value.}

\item{method}{String indicating the method to use. The available methods are:
"greedy.weighted": Sort all pairs according to a greedy (heuristic) Euler path with x as weights visiting each edge precisely once.
"strictly.weighted": Strictly respect the order of the weights - so the first, second, third, and so on, adjacent pair of numbers
of the output of zenpath() corresponds to the pair with largest, second-largest, third-largest, and so on, weight.
see zenpath}

\item{connect}{If connect is TRUE, connect the edges from separate eulerians (strictly.weighted only).}
}
\value{
Returns a zpath from viv showing pairs with viv entry over the cutoff
}
\description{
Constructs a zenpath for connecting and displaying pairs.
}
\details{
Construct a path of indices to visit to order variables
}
\examples{
\dontrun{
# To use this function, install zenplots and graph from Bioconductor.
if (!requireNamespace("graph", quietly = TRUE)) {
  install.packages("BiocManager")
  BiocManager::install("graph")
}
install.packages("zenplots")

aq <- na.omit(airquality) * 1.0

# Run an mlr3 ranger model:
library(mlr3)
library(mlr3learners)
library(ranger)
ozonet <- TaskRegr$new(id = "airQ", backend = aq, target = "Ozone")
ozonel <- lrn("regr.ranger", importance = "permutation")
ozonef <- ozonel$train(ozonet)

viv <- vivi(aq, ozonef, "Ozone")

# Calculate Zpath:
zpath <- zPath(viv, .8)
zpath
}
}
