% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_ch_ratio.R
\name{flag_ch_ratio}
\alias{flag_ch_ratio}
\title{Flag unusual high collaboration hours to after-hours collaboration
hours ratio}
\usage{
flag_ch_ratio(data, threshold = c(1, 30), return = "message")
}
\arguments{
\item{data}{A data frame containing a Person Query.}

\item{threshold}{Numeric value specifying the threshold for flagging.
Defaults to 30.}

\item{return}{String to specify what to return. Options include:
\itemize{
\item \code{"message"}
\item \code{"text"}
\item \code{"data"}
}}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"message"}: message in the console containing diagnostic summary
\item \code{"text"}: string containing diagnostic summary
\item \code{"data"}: data frame. Person-level data with flags on unusually high or
low ratios
}
}
\description{
This function flags persons who have an unusual ratio
of collaboration hours to after-hours collaboration hours.
Returns a character string by default.
}
\section{Metrics used}{

The metric \code{Collaboration_hours} is used in the calculations. Please ensure
that your query contains a metric with the exact same name.
}

\examples{
flag_ch_ratio(pq_data)


data.frame(PersonId = c("Alice", "Bob"),
           Collaboration_hours = c(30, 0.5),
           After_hours_collaboration_hours = c(0.5, 30)) \%>\%
  flag_ch_ratio()

}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_trend}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_shifts}()},
\code{\link{identify_tenure}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}
}
\concept{Data Validation}
