% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_package.R
\name{parameters}
\alias{parameters}
\title{Parameters}
\arguments{
\item{obs.y}{Observed data matrix with \eqn{l} rows and 4 columns. Row \eqn{k} in the matrix
    represents the observed data from dose level \eqn{k}. The columns are

\itemize{
    \item{column 1: }{number of patient with no DLT, no immune response}
    \item{column 2: }{number of patient with no DLT, immune response}
    \item{column 3: }{number of patient with DLT, no immune response}
    \item{column 4: }{number of patient with DLT, immune response}
}}

\item{prob.mdl}{Option of the probability models:

\itemize{\item{NONPARA: }{non-parametric+ model}

 \item{NONPARA+: }{non-parametric model}

\item{PARA: }{partially parametric model}

\item{PARA+: }{partially parametric+ model} }

Default value is \code{NONPARA}. See \code{\link{visit}} for details.}

\item{priors}{A class \code{VTPRIOR} object created by
\code{\link{vtPriorPar}} for \code{PARA} and \code{PARA+} model.}

\item{etas}{Vector of length 2 representing \eqn{(p_L, p_U)}. \eqn{p_L}: lower
bound of DLT risk, below which the current dose is considered absolutely
safe; \eqn{p_U}: upper bound of DLT risk above which the current dose is
considered too toxic}

\item{prev.res}{Response rate from the next lower dose level, say, \eqn{l-1}.
This can be a scalar representing the mean of the response rate
\eqn{E(q^{(l-1)})}, or a vector of posterior samples of the response rate
\eqn{q^{(l-1)}}. For \eqn{l=1}, this value is set to \eqn{0}.}

\item{dec.cut}{Thresholds \eqn{C_1,C_2,C_3}. If the vector length is shorter
than \eqn{3}, it is repeated to have \eqn{3} elements. See
\code{\link{visit}} for details.}

\item{digits}{Digits for print}

\item{seed}{Random seed}

\item{...}{Reserved parameters}
}
\description{
Parameters that are shared by multiple functions
}
