% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Vector2String.R
\name{vector2String}
\alias{vector2String}
\title{Convert a vector into a comma-separated string}
\usage{
vector2String(vec)
}
\arguments{
\item{vec}{The (usually real or complex valued) vector to be converted.}
}
\value{
A string, where the former vector elements are separated by commas,
  enclosed between "c(" and ")".
}
\description{
A simple utility function that transforms any vector into a single character
string, where the former vector elements are separated by commas. This is can
be useful, in some circumstances, for feeding a series of constant numeric
values to \code{\link{phasePortrait}} (see examples). For most applications
we recommend, however, to use \code{\link{phasePortrait}}'s parameter
\code{moreArgs} instead.
}
\examples{
# Make a vector of 77 complex random numbers inside the unit circle
n <- 77
a <- complex(n, modulus = runif(n), argument = 2*pi*runif(n))
a <- vector2String(a)
print(a)


# Use this for portraying a Blaschke product
\donttest{
# x11(width = 9.45, height = 6.30) # Screen device commented out
                                   # due to CRAN test requirements.
                                   # Use it when trying this example
op <- par(mar = c(1, 1, 1, 1), bg = "black")
n <- 77
a <- complex(n, modulus = runif(n), argument = 2*pi*runif(n))
a <- vector2String(a)
FUN <- paste("vapply(z, function(z, a){
                    return(prod(abs(a)/a * (a-z)/(1-Conj(a)*z)))
                   }, a =", a,
             ", FUN.VALUE = complex(1))", sep = "")
phasePortrait(FUN, pType = "p", axes = FALSE,
              xlim = c(-3, 3), ylim = c(-2.0, 2.0),
              nCores = 2) # Max. two cores allowed on CRAN
                          # not a limit for your own use
par(op)
  \dontshow{
  # R CMD check: make sure any open connections are closed afterward
  foreach::registerDoSEQ()
  doParallel::stopImplicitCluster()
  }
}


}
\seealso{
Other helpers: 
\code{\link{xlimFromYlim}()},
\code{\link{ylimFromXlim}()}
}
\concept{helpers}
