% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_and_visuals.R
\name{vis_anova_assumptions}
\alias{vis_anova_assumptions}
\title{Testing ANOVA assumptions}
\usage{
vis_anova_assumptions(
  samples,
  fact,
  conf.level = 0.95,
  samplename = "",
  factorname = "",
  cex = 1
)
}
\arguments{
\item{samples}{vector containing dependent variable, datatype numeric}

\item{fact}{vector containing independent variable, datatype factor}

\item{conf.level}{confidence level, 0.95=default}

\item{samplename}{name of sample used in graphical output, dataype character , ""=default}

\item{factorname}{name of sample used in graphical output, dataype character, ""=default}

\item{cex}{number indicating the amount by which plotting text and symbols should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}
}
\value{
my_list: list containing the test statistics of the anova
\code{aov(samples~fact)},\code{bartlett.test(samples~fact)} and the tests of normality of the standardized residuals of aov, \code{ks_test} and \code{shapiro_test}
}
\description{
\code{vis_anova_assumptions} checks for normality of the standardised residuals of the anova both graphically by qq-plots as well as performing
   the Shapiro-Wilk-test \code{shapiro.test} and the Anderson-Darling-Test \code{ad.test}.
   \code{aov} further tests the homoscedacity of each factor level in \code{fact} with the \code{bartlett.test}.
}
\examples{
ToothGrowth$dose=as.factor(ToothGrowth$dose)
vis_anova_assumptions(ToothGrowth$len, ToothGrowth$dose)

vis_anova_assumptions(ToothGrowth$len, ToothGrowth$supp)
vis_anova_assumptions(iris$Petal.Width,iris$Species)
}
