% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_attrition.R
\name{apply_attrition}
\alias{apply_attrition}
\title{Apply list of inclusion/exclusion criteria to a patient-level dataframe}
\usage{
apply_attrition(data, criteria_conditions)
}
\arguments{
\item{data}{\code{data.frame}. Data set to be filtered}

\item{criteria_conditions}{\code{character} dplyr-filter compatible conditions
of the filtering criteria. These conditions will be applied to filter the input
data set and obtain final analysis data set}
}
\value{
Filtered data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
Apply list of inclusion/exclusion criteria to a patient-level dataframe
}
\examples{
adtte_filtered <- visR::apply_attrition(adtte,
  criteria_conditions = c(
    "TRTP=='Placebo'", "AGE>=75",
    "RACE=='WHITE'", "SITEID==709"
  )
)

}
