% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatEstimateName.R
\name{formatEstimateName}
\alias{formatEstimateName}
\title{Format estimate_name and estimate_value column}
\usage{
formatEstimateName(
  result,
  estimateNameFormat = NULL,
  keepNotFormatted = TRUE,
  useFormatOrder = TRUE
)
}
\arguments{
\item{result}{A summarised_result or compared_result.}

\item{estimateNameFormat}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{keepNotFormatted}{Whether to keep rows not formatted.}

\item{useFormatOrder}{Whether to use the order in which estimate names
appear in the estimateNameFormat argument (TRUE), or use the order in the
input dataframe (FALSE).}
}
\value{
A summarised_result object withspecified changes in estimate_name and
estimate_value.
}
\description{
Format estimate_name and estimate_value column of summarised_result and
compared_result object, by changing the name of the estimate name and/or joining
diferent estimate names together in a row.
}
\examples{
\donttest{
result <- mockSummarisedResult()
result |>
  formatEstimateName(
    estimateNameFormat = c(
      "N (\%)" = "<count> (<percentage>\%)", "N" = "<count>"
    ),
    keepNotFormatted = FALSE
  )
}

}
