% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qtl.R
\name{breeding_values}
\alias{breeding_values}
\title{Estimate breeding values - Adapted function from QTLpoly}
\usage{
breeding_values(qtl_info, probs, selected_mks, blups, beta.hat, pos)
}
\arguments{
\item{qtl_info}{data.frame with: LG - linkage group ID; Pos - position in linkage map (cM); 
Pheno - phenotype ID; Pos_lower - lower position of confidence interval; 
Pos_upper - upper position of the confidence interval; Pval - QTL p-value; h2 - herdability}

\item{probs}{data.frame with first column (named `ind`) as individuals ID and next columns 
named with markers ID and containing the genotype probability at each marker}

\item{selected_mks}{data.frame with: LG - linkage group ID; mk - marker ID; pos - position in linkage map (cM)}

\item{blups}{data.frame with: haplo - haplotype ID; pheno - phenotype ID; qtl - QTL ID; u.hat - QTL estimated BLUPs}

\item{beta.hat}{data.frame with: pheno - phenotype ID; beta.hat - estimated beta}

\item{pos}{selected QTL position (cM)}
}
\value{
data.frame containing breeding values
}
\description{
Estimate breeding values - Adapted function from QTLpoly
}
\keyword{internal}
