% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{XArray-class}
\alias{XArray-class}
\alias{XArray}
\title{Virtual array of general R objects}
\arguments{
\item{stack}{A \code{list}-class object.}

\item{index}{A \code{vector}, \code{matrix} or \code{array} type object. Includes the indices of layers in the stack.}

\item{dim}{A \code{numeric} vector. Same as for \code{array}, creates \code{proxy} procedurally.}
}
\value{
An \code{XArray}-class object.
}
\description{
Template for construction of virtual arrays ('\code{VirtualArray}') and a derived class ('\code{XArray}') to instantiate it with general objects.
}
\details{
The '\code{VirtualArray}' class implements structures to organize objects of the same class in multidimensional arrays. Subsetting rules were defined using the proxy object in the \code{index} slot. The '\code{VirtualArray}' is the base class for '\code{XArray}' and '\code{\link[via:RasterArray-class]{RasterArray}}' classes.
The '\code{XArray}' class derived from \code{VirtualArray} allows the instantiation of basic virtual arrays with genearl R objects, which form a single \code{list} in the \code{@stack slot}. The '\code{\link[via:SfArray-class]{SfArray}}' class is derived from the '\code{XArray}' class.

The class has two slots:
\code{@stack}: A list containing objects of the same class (i.e. layers).
\code{@index}: A proxy object that represents the structure of the entities.
}
\examples{
# 2d XArray of vectors
  data(exemplar)
  st <-exemplar@stack
  ind <- 1:nlayers(st)
  dim(ind) <- c(3,4)
  dimnames(ind) <- list(n = c(10, 20, 30), seed = 1:4)
  xa<- XArray(stack=st, index=ind)
  
}
