% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice_diffs}
\alias{slice_diffs}
\title{Show rows which have differing values in a comparison}
\usage{
slice_diffs(table, comparison, column)
}
\arguments{
\item{table}{A data frame. One of \code{table_a} or \code{table_b} used to
create \code{comparison}}

\item{comparison}{The output of a \code{versus::compare()} call}

\item{column}{<\code{\link[=versus_tidy_select]{tidy-select}}>. A row will be in the output of slice functions if
the comparison shows differing values for any columns matching this argument}
}
\value{
A data frame. The input \code{table} is filtered to only the rows for which
\code{comparison} shows differing values for one of the columns in the supplied
\code{column} argument
}
\description{
Show rows which have differing values in a comparison
}
\examples{
comp <- compare(example_df_a, example_df_b, by = car)
example_df_a |> slice_diffs(comp, disp)
example_df_a |> slice_diffs(comp, c(disp, mpg))
}
