% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniformConfidence.R
\name{uniformExtinction}
\alias{uniformExtinction}
\alias{uniformExtinction,uniformOrigination}
\alias{uniformOrigination}
\title{Uniform Confidence Intervals}
\usage{
uniformExtinction(Ages, Confidence = 0.95)

uniformOrigination(Ages, Confidence = 0.95)
}
\arguments{
\item{Ages}{a numeric vector of fossil occurrence ages, expressed as millions of years ago.}

\item{Confidence}{the desired confidence level}
}
\value{
A matrix listing the earliest and latest estimate for extinction or origination.
}
\description{
Estimate a confidence interval on time of extinction or origination when assuming a uniform probability of collection.
}
\details{
Takes a numeric vector of fossil occurrence ages, expressed as millions of years ago, to estimate either the time of origination \code{uniformOrigination} or extinction \code{uniformExtinction}.
This code uses Marshall's adaptation of the function by Strauss and Sadler.

Marshall, C.R. (1990) "Confidence intervals on stratigraphic ranges" \emph{Paleobiology} 16:1-10.
}
\examples{
# Generate an exmaple dataset of fossil ages
FakeAges<-runif(50,50,100)

# Calculate the inferred age of extinction with 95\% confidence.
uniformExtinction(FakeAges,Confidence=0.95)

# Calculate the inferred age of origination with 50\% confidence.
uniformOrigination(FakeAges,Confidence=0.5)

}
\author{
Andrew A. Zaffos
}

