% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/veg_diversity.R
\name{veg_diverstiy}
\alias{veg_diverstiy}
\alias{shannon}
\alias{evenness}
\alias{dominance}
\alias{simpson}
\alias{richness}
\alias{veg_diversity}
\alias{veg_diversity.vegtable}
\alias{veg_diversity,vegtable-method}
\title{Calculation of statistics at plot level}
\usage{
shannon(x, na.rm = TRUE, ...)

evenness(x, ...)

dominance(x, ...)

simpson(x, na.rm = TRUE, ...)

richness(x, na.rm = TRUE, ...)

veg_diversity(object, ...)

\method{veg_diversity}{vegtable}(
  object,
  weight,
  FUN = shannon,
  aggr_fun = mean,
  arg_fun = list(),
  var_name,
  in_header = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector containing the abundance of single species.}

\item{na.rm}{A logical value indicating whether NA values should be removed
from the abundance vector or not.}

\item{...}{Further arguments passed among methods. In \code{'evenness()'} and
\code{'dominance()'}, these arguments are passed to \code{'shannon()'}.
In \code{'veg_diversity()'}, these arguments are passed to \code{\link[=aggregate]{aggregate()}}
(actually to \code{'FUN'}).}

\item{object}{A \linkS4class{vegtable} object.}

\item{weight}{A character value indicating the name of the column at slot
\strong{samples} which will be used as species abundance.}

\item{FUN}{A function used to calculate the diversity index.}

\item{aggr_fun}{A function used to aggregate abundance values for multiple
records of a taxon in a plot observation. Average value is used by
default.}

\item{arg_fun}{A named list with parameters and arguments passed to
\code{\link[=taxa2samples]{taxa2samples()}}, which will
retrieve the respective taxon concept for each taxon usage name and can
be used to merge taxa at a determined taxonomic rank, for instance to
merge all sub-specific taxa into their respective species
(i.e. \code{'merge_to = "species"'}).}

\item{var_name}{A character value used as name for the calculated index.
If missing, the name of the function will be used.}

\item{in_header}{A logical value indicating whether the results should be
included as variables in the slot \strong{header} of the input object.
If \code{'in_header = TRUE'}, you may assign the result of the function to the
input object.}
}
\value{
Functions \code{shannon()}, \code{evenness()}, \code{dominance()}, \code{simpson()}, and
\code{richness()} return a numeric value (the calculated index).

Funtion \code{veg_diversity()} produce either a data frame with calculated values
per plot observation (option \code{'in_header = FALSE'}) or a \linkS4class{vegtable}
object with the calculated values inserted in the slot \strong{header}
(option \code{'in_header = TRUE'}).
}
\description{
Calculation of diversity statistics at the plot level allowing for customized
functions defined as \code{foo(x, ...)}, where \code{x} is the vector of abundance
values.

This function calls \code{\link[=taxa2samples]{taxa2samples()}} to derive taxa from taxon usage names in
slot \strong{samples} and multiple records of species in a single plot will be
merged by \link[=aggregate]{stats::aggregate}.

The functions \code{shannon()}, \code{evenness()}, and \code{dominance()} calculate the
diversity index of Shannon, the evenness, and the dominance
(\emph{1 - evenness}), respectively.
Dominance is the complementary value to evenness (i.e. \code{1 - evenness}).

The function \code{simpson()} calculates the Simpson's index using the alternative
for vegetation plot observations.

The function \code{richness()} counts the number of taxa per plot and can be used
as alternative to \link[=count_taxa]{vegtable::count_taxa}.
}
\examples{
## Compare Evenness with Shannon index
Kenya_veg <- cover_trans(x = Kenya_veg, to = "cover")
Kenya_veg <- veg_diversity(object = Kenya_veg, weight = "cover")
Kenya_veg <- veg_diversity(object = Kenya_veg, weight = "cover", FUN = evenness)

with(Kenya_veg@header, plot(shannon, evenness))

}
