% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.list.R
\name{as.list}
\alias{as.list}
\alias{as.list,vegtable-method}
\alias{as.list,coverconvert-method}
\title{Coerce an S4 object to a list}
\usage{
\S4method{as.list}{vegtable}(x, ...)

\S4method{as.list}{coverconvert}(x, ...)
}
\arguments{
\item{x}{an object of class \linkS4class{coverconvert} or \linkS4class{vegtable}}

\item{...}{further arguments passed from or to other methods.}
}
\value{
An object of class \code{list}.
}
\description{
Coercion used to explore content in S4 objects.

S4 objects will be coerced to lists, where each slot in the input object
becomes a member of the output list. This way allows to explore content and
solve problems when validity checks fail.
}
\examples{
## Head of slot 'taxonNames'
class(Easplist)
head(Easplist@taxonNames)

## The same after coercing to list
Easplist <- as.list(Easplist)
class(Easplist)
head(Easplist$taxonNames)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
