% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctions.R
\name{calc_estimate_true_var}
\alias{calc_estimate_true_var}
\alias{calc_estimate_true_var.default}
\alias{calc_estimate_true_var.rmult}
\title{Estimate true group variance}
\usage{
calc_estimate_true_var(x, ...)

\method{calc_estimate_true_var}{default}(x, individual_var, force_pos_def = T, ...)

\method{calc_estimate_true_var}{rmult}(x, individual_var, force_pos_def = T, ...)
}
\arguments{
\item{x}{a matrix of data}

\item{...}{...}

\item{individual_var}{a matrix of cell-wise uncertainties, corresponding to the entries of 'x'}

\item{force_pos_def}{force positive definiteness of the new group variances, default TRUE}
}
\value{
matrix of corrected group variance
}
\description{
Estimation of true group variance incorporating observation wise variances.
The function uses the data from x and the individual variances for each observation, for example derived from uncertainties, to calculate a 'true' group variance.
The variance of the matrix is corrected for the sum of the individual variances of the data set, which is normalized to the number of rows of the matrix.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: for class matrix or data.frame

\item \code{rmult}: for class rmult
}}

\author{
Solveig Pospiech, K. Gerald v.d. Boogaart
}
