% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.R
\name{vec_order}
\alias{vec_order}
\alias{vec_sort}
\title{Order and sort vectors}
\usage{
vec_order(x, direction = c("asc", "desc"), na_value = c("largest", "smallest"))

vec_sort(x, direction = c("asc", "desc"), na_value = c("largest", "smallest"))
}
\arguments{
\item{x}{A vector}

\item{direction}{Direction to sort in. Defaults to \code{asc}ending.}

\item{na_value}{Should \code{NA}s be treated as the largest or smallest values?}
}
\value{
\itemize{
\item \code{vec_order()} an integer vector the same size as \code{x}.
\item \code{vec_sort()} a vector with the same size and type as \code{x}.
}
}
\description{
Order and sort vectors
}
\section{Differences with \code{order()}}{

Unlike the \code{na.last} argument of \code{order()} which decides the
positions of missing values irrespective of the \code{decreasing}
argument, the \code{na_value} argument of \code{vec_order()} interacts with
\code{direction}. If missing values are considered the largest value,
they will appear last in ascending order, and first in descending
order.
}

\section{Dependencies of \code{vec_order()}}{

\itemize{
\item \code{\link[=vec_proxy_order]{vec_proxy_order()}}
}
}

\section{Dependencies of \code{vec_sort()}}{

\itemize{
\item \code{\link[=vec_proxy_order]{vec_proxy_order()}}
\item \code{\link[=vec_order]{vec_order()}}
\item \code{\link[=vec_slice]{vec_slice()}}
}
}

\examples{
x <- round(c(runif(9), NA), 3)
vec_order(x)
vec_sort(x)
vec_sort(x, "desc")

# Can also handle data frames
df <- data.frame(g = sample(2, 10, replace = TRUE), x = x)
vec_order(df)
vec_sort(df)
vec_sort(df, "desc")

# Missing values interpreted as largest values are last when
# in increasing order:
vec_order(c(1, NA), na_value = "largest", direction = "asc")
vec_order(c(1, NA), na_value = "largest", direction = "desc")
}
