% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.stdmean.ps}
\alias{meta.lc.stdmean.ps}
\title{Confidence interval for a linear contrast of standardized
mean differences from paired-samples studies}
\usage{
meta.lc.stdmean.ps(alpha, m1, m2, sd1, sd2, cor, n, v, stdzr)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for group 1}

\item{m2}{vector of estimated means for group 2}

\item{sd1}{vector of estimated SDs for group 1}

\item{sd2}{vector of estimated SDs for group 2}

\item{cor}{vector of estimated correlations for paired measurements}

\item{n}{vector of sample sizes}

\item{v}{vector of contrast coefficients}

\item{stdzr}{\itemize{
\item set to 0 for square root unweighted average variance standardizer
\item set to 1 for group 1 SD standardizer
\item set to 2 for group 2 SD standardizer
}}
}
\value{
Returns 1-row matrix with the following columns:
\itemize{
\item Estimate - estimate of linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
linear contrast of paired-samples standardized mean differences from two or
more studies. Equality of variances within or across studies is not assumed.
}
\examples{
m1 <- c(53, 60, 53, 57)
m2 <- c(55, 62, 58, 61)
sd1 <- c(4.1, 4.2, 4.5, 4.0)
sd2 <- c(4.2, 4.7, 4.9, 4.8)
cor <- c(.7, .7, .8, .85)
n <- c(30, 50, 30, 70)
v <- c(.5, .5, -.5, -.5)
meta.lc.stdmean.ps(.05, m1, m2, sd1, sd2, cor, n, v, 0)

# Should return:
#            Estimate        SE        LL        UL
# Contrast  0.5127577 0.1392232 0.2398851 0.7856302


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
