% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_area}
\alias{v_area}
\title{Create an Area Chart}
\usage{
v_area(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  stack = FALSE,
  area = list(style = list(curveType = "linear", fill = NULL, fillOpacity = NULL)),
  point = list(visible = FALSE),
  line = list(visible = FALSE),
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{stack}{Whether to stack the data or not (if \code{fill} aesthetic is provided).}

\item{area}{Area's options, such as curve interpolation type, see \href{https://www.visactor.io/vchart/option/AreaChart#area.style.curveType}{online documentation}.}

\item{point}{Options for showing points on lines or not.}

\item{line}{Options for showing lines or not.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create an Area Chart
}
\examples{

library(vchartr)

# Basic Area Chart
vchart(eco2mix) \%>\%
  v_area(aes(date, solar))

# Two areas
vchart(eco2mix, aes(date)) \%>\%
  v_area(aes(y = wind)) \%>\%
  v_area(aes(y = solar))

# Line chart with discrete x axis
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\%
  v_area(aes(month, value))

# Fill color
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\%
  v_area(
    aes(month, value),
    area = list(
      style = list(fill = "firebrick", fill_opacity = 0.9)
    )
  )

# Smooth Area Chart
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\%
  v_area(
    aes(month, value),
    area =  list(
      style = list(curveType = "monotone")
    )
  )

# Step Area Chart
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\%
  v_area(
    aes(month, value),
    area = list(
      style = list(curveType = "stepAfter")
    )
  )

# Multiple areas
vchart(eco2mix_long) \%>\%
  v_area(aes(date, production, fill = source))

vchart(eco2mix_long) \%>\%
  v_area(
    aes(date, production, fill = source),
    stack = TRUE,
    area = list(
      style = list(fillOpacity = 1)
    )
  )


# Range area chart
vchart(temperatures, aes(date)) \%>\%
  v_area(aes(ymin = low, ymax = high)) \%>\%
  v_line(aes(y = average))

within(temperatures, {difference = `2024` - average}) \%>\%
  vchart(aes(date)) \%>\%
  v_area(
    aes(ymin = average, ymax = `2024`, difference = difference),
    area = list(
      style = list(
        fill = JS(
          "data => { return data.difference > 0 ? '#F68180' : '#2F64FF' ; }"
        ),
        fillOpacity = 1
      )
    )
  )
}
