% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_anova.R
\name{vascr_plot_anova}
\alias{vascr_plot_anova}
\title{Make a display with all the ANOVA analysis pre-conducted}
\usage{
vascr_plot_anova(
  data.df,
  unit,
  frequency,
  time,
  reference = NULL,
  separate = "x",
  rotate = 45
)
}
\arguments{
\item{data.df}{vascr dataset to plot}

\item{unit}{unit to plot}

\item{frequency}{frequency to plot}

\item{time}{timepoint to plot at}

\item{reference}{Sample to reference post-hoc analysis to}

\item{separate}{Value to use when separating comparasons in the output (default x)}

\item{rotate}{degrees of rotation used for labeling the X axis}
}
\value{
A matrix of different ANOVA tests
}
\description{
Make a display with all the ANOVA analysis pre-conducted
}
\examples{
\donttest{
# Run, comparing only to a reference
vascr_plot_anova(data.df = small_growth.df, unit = "R", frequency = 4000, time = 100, 
          reference = "5,000_cells + HCMEC D3_line")
}
}
