% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pen_functions.R
\name{d.SCAD}
\alias{d.SCAD}
\title{Derivative of Smoothly Clipped Absolute Deviation Penalty}
\usage{
d.SCAD(x, lambda = 1, a = 3.7, d.side = "both")
}
\arguments{
\item{x}{numeric.}

\item{lambda}{non-negative scalar, shrinkage parameter.}

\item{a}{scalar larger than 2. Fan & Li (2001) suggest \eqn{a = 3.7}.}

\item{d.side}{side of serivative at origin. Default value is \code{"both"}, returning NA for \code{x == 0}. If set to \code{"RHS"}, then returns RHS derivative, i.e., \eqn{\lambda}, and \eqn{-\lambda} with \code{"LHS"}.}
}
\value{
derivative of \code{SCAD(x)}, for \code{x == 0} return value is \code{NA}.
}
\description{
derivative of \code{\link{SCAD}}, which is not differentiable at \code{x == 0}.
}
\examples{

d.SCAD(-5:5)
d.SCAD(-2:2, d.side = "LHS")
curve(d.SCAD, from = -5, to = 5)
}
\author{
Jakob Dambon
}
