% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{fullSVC_reggrid}
\alias{fullSVC_reggrid}
\title{Sample Function for SVCs}
\usage{
fullSVC_reggrid(m, p, cov_pars, nugget, seed = 123)
}
\arguments{
\item{m}{integer. square root number of observations, in total the function will sample \eqn{m^2} locations on a regular grid.}

\item{p}{integer. number of SVC}

\item{cov_pars}{data.frame including the covariance parameters of SVCs, using an exponential covariance function. The columns must have the names \code{"var"} and \code{"scale"}.}

\item{nugget}{scalar. variance of the nugget / error term.}

\item{seed}{integer. seed for sampling}
}
\value{
object of class \code{SpatialPointsDataFrame} (see \code{\link[sp]{SpatialPointsDataFrame-class}}) of the sampled SVC including the nugget.
}
\description{
Samples SVC on a regular grid. The SVC have all mean 0.
}
\examples{
# number of SVC
p <- 3
# sqrt of total number of observations
m <- 20
# covariance parameters
(pars <- data.frame(var = c(0.1, 0.2, 0.3), 
                    scale = c(0.3, 0.1, 0.2)))
nugget.var <- 0.05

# function to sample SVCs
sp.SVC <- fullSVC_reggrid(m = m, p = p, 
                          cov_pars = pars, 
                          nugget = nugget.var)

library(sp)
# visualization of sampled SVC
spplot(sp.SVC, colorkey = TRUE)

}
