
library("variables")

x1 <- numeric_var("d_vari", "double", "cm", support = c(0.0, 1.5))
variable.names(x1)
desc(x1)
unit(x1)
support(x1)
levels(x1)
bounds(x1)
is.bounded(x1)
mkgrid(x1)
as.data.frame(x1)

x2 <- numeric_var("i_vari", "integer", "cm", support = 1:10)
variable.names(x2)
desc(x2)
unit(x2)
support(x2)
levels(x2)
bounds(x2)
is.bounded(x2)
mkgrid(x2)
as.data.frame(x2)

x3 <- numeric_var("dd_vari", "discrete double", "cm", support = 1:4/6)
variable.names(x3)
desc(x3)
unit(x3)
support(x3)
levels(x3)
bounds(x3)
is.bounded(x3)
mkgrid(x3)
as.data.frame(x3)

x4 <- numeric_var("db_vari", "bounded double", "cm", support = c(0.1, 1.4), bounds = c(0.0, 1.5))
variable.names(x4)
desc(x4)
unit(x4)
support(x4)
levels(x4)
bounds(x4)
is.bounded(x4)
mkgrid(x4)
as.data.frame(x4)

x5 <- ordered_var("o_vari", "ordered", LETTERS[1:3])
variable.names(x5)
desc(x5)
unit(x5)
support(x5)
levels(x5)
bounds(x5)
is.bounded(x5)
as.data.frame(x5)

x6 <- factor_var("f_vari", "unordered", LETTERS[1:3])
variable.names(x6)
desc(x6)
unit(x6)
support(x6)
levels(x6)
bounds(x6)
is.bounded(x6)
as.data.frame(x6)

xy <- c(x1, x2, x3, x4, x5, x6)
names(xy)
desc(xy)
unit(xy)
support(xy)
levels(xy)
bounds(xy)
is.bounded(xy)
mkgrid(xy, n = 3)
dxy <- as.data.frame(xy, n = 10)
check(xy, dxy)
sapply(xy, check, data = dxy)
