% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_input_attributes.R
\name{vapour_layer_names}
\alias{vapour_layer_names}
\title{Read GDAL layer names}
\usage{
vapour_layer_names(dsource, ...)
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL)}

\item{...}{arguments ignore for deprecated compatibility (no 'sql' argument any longer)}
}
\value{
character vector of layer names
}
\description{
Obtain the names of available layers from a GDAL vector source.
}
\details{
Some vector sources have multiple layers while many have only one. Shapefiles
for example have only one, and the single layer gets the file name with no path
and no extension. GDAL provides a quirk for shapefiles in that a directory may
act as a data source, and any shapefile in that directory acts like a layer of that
data source. This is a little like the one-or-many sleight that exists for raster
data sources with subdatasets (there's no way to virtualize single rasters into
a data source with multiple subdatasets, oh except by using VRT....)

See \link{vapour_sds_names} for more on the multiple topic.
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
vapour_layer_names(mvfile)
}
