% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{BoundWaterEnvPlots}
\alias{BoundWaterEnvPlots}
\title{Bound Water Environment Barplots}
\usage{
BoundWaterEnvPlots(data, passed.waters = TRUE, pct.conserved.gte = 50,
  num.clusters = 50)
}
\arguments{
\item{data}{The \code{h2o.clusters.summary} data.frame from the
\code{ClusterWaters} function containing the \code{nBvalue.mu}
information.}

\item{passed.waters}{Logical indicator to plot results for waters \strong{passing}
\code{\link[=Mobility]{Mobility()}} and \code{\link[=NormalizedBvalue]{NormalizedBvalue()}} \emph{\strong{OR}} using \strong{all} waters within
the \code{PDB} files.}

\item{pct.conserved.gte}{minimum percent conservation within a water cluster;
default: \code{50.0}If the number of clusters is less than the number of
clusters defined by \code{num.clusters}, then the number of clusters defined by
\code{pct.conserved.gte} is displayed.}

\item{num.clusters}{number (integer) of clusters to display. If the number of
clusters is less than the number of clusters defined by
\code{pct.conserved.gte}, then the number of clusters defined by \code{num.clusters}
is displayed. A value of \code{NULL} results in the provided value for
\code{pct.conserved.gte} being used.}
}
\description{
Normalized B-value Barplots for Cluster with at least 50\%
Conservation
}
\details{
Constructs a barplot with corresponding density plot for the mean
normalized B-value value for all water within each cluster with at least
50\% water conservation. Clusters with 50 to 69\% water conseration are dark
red, clusters with 70 to 79\% conservation are red, 80 to 89\% conservation
are light blue, 90 to 99\% conservation are blue, and 100\% conservation
(waters from all structures) are dark blue.

The normalized B-value values are calculated by the
\code{NormalizedBvalue} function.

This plot was inspired by Figure 1 of Sanschagrin and Kuhn (1998).
}
\examples{
  \dontrun{
  bwe.plots <- BoundWaterEnvPlots(data=thrombin10.conservedWaters,
                                  passed.waters=TRUE,
                                  pct.conserved.gte = 50.0,
                                  num.clusters = 50)
  }

}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}
}
\seealso{
Other plots: \code{\link{BoundWaterEnvSummaryPlot}},
  \code{\link{BvalueBarplot.summ}},
  \code{\link{BvalueBarplot}},
  \code{\link{ClusterSummaryPlots}},
  \code{\link{MobNormBvalEvalPlots}},
  \code{\link{MobilityBarplot.summ}},
  \code{\link{MobilityBarplot}},
  \code{\link{OccupancyBarplot.summ}},
  \code{\link{OccupancyBarplot}},
  \code{\link{nBvalueBarplot}},
  \code{\link{normBvalueBarplot.summ}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{plots}
