% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{glucose_methods}
\alias{glucose_methods}
\title{Glucose Method Comparison Dataset}
\format{
A data frame with 60 observations and 3 variables:
\describe{
\item{sample_id}{Character. Unique sample identifier.}
\item{reference}{Numeric. Glucose concentration (mg/dL) measured by the
reference hexokinase method.}
\item{poc_meter}{Numeric. Glucose concentration (mg/dL) measured by the
point-of-care glucose meter.}
}
}
\source{
Synthetic data generated to mimic realistic clinical patterns. See
\code{data-raw/make_datasets.R} for the generation script.
}
\usage{
glucose_methods
}
\description{
Synthetic dataset comparing glucose measurements from two analytical methods:
a reference hexokinase-based laboratory analyzer and a point-of-care (POC)
glucose meter. The data mimics realistic patterns observed in clinical
laboratory method validation studies.
}
\details{
This synthetic dataset was designed to illustrate common patterns in glucose
method comparisons:

\itemize{
\item \strong{Concentration range}: 50-350 mg/dL, covering hypoglycemia through
severe hyperglycemia
\item \strong{Bias pattern}: The POC meter shows a small positive bias (~3-5 mg/dL)
with slight proportional error at higher concentrations
\item \strong{Precision}: Reference method CV ~2.5\%, POC meter CV ~4.5\%
}

The data is suitable for demonstrating Bland-Altman analysis, Passing-Bablok
regression, and other method comparison techniques.
}
\examples{
# Bland-Altman analysis
ba <- ba_analysis(reference ~ poc_meter, data = glucose_methods)
summary(ba)
plot(ba)

# Check for proportional bias
plot(ba, title = "POC Glucose Meter vs Reference")

}
\seealso{
\code{\link[=ba_analysis]{ba_analysis()}}, \link{creatinine_serum}, \link{troponin_cardiac}
}
\keyword{datasets}
