% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_window.r
\name{bed_window}
\alias{bed_window}
\title{Identify intervals within a specified distance.}
\usage{
bed_window(x, y, genome, ...)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{y}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{genome}{\code{\link[=tbl_genome]{tbl_genome()}}}

\item{...}{params for bed_slop and bed_intersect}
}
\description{
Identify intervals within a specified distance.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- trbl_interval(
 ~chrom, ~start, ~end,
 'chr1', 25,     50,
 'chr1', 100,    125
)

y <- trbl_interval(
  ~chrom, ~start, ~end,
  'chr1', 60,     75
)

genome <- trbl_genome(
  ~chrom, ~size,
  'chr1', 125
)

bed_glyph(bed_window(x, y, genome, both = 15))

x <- trbl_interval(
  ~chrom, ~start, ~end,
  "chr1", 10,    100,
  "chr2", 200,    400,
  "chr2", 300,    500,
  "chr2", 800,    900
)

y <- trbl_interval(
  ~chrom, ~start, ~end,
  "chr1", 150,    400,
  "chr2", 230,    430,
  "chr2", 350,    430
)

genome <- trbl_genome(
  ~chrom, ~size,
  "chr1", 500,
  "chr2", 1000
)

bed_window(x, y, genome, both = 100)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/window.html}

Other multiple set operations: \code{\link{bed_closest}},
  \code{\link{bed_coverage}}, \code{\link{bed_intersect}},
  \code{\link{bed_map}}, \code{\link{bed_subtract}}
}
\concept{multiple set operations}
