% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/confrontation.R
\docType{methods}
\name{sort,validation-method}
\alias{sort,validation-method}
\title{Aggregate and sort the results of a validation.}
\usage{
\S4method{sort}{validation}(x, decreasing = FALSE, by = c("rule", "record"),
  drop = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{validation}}}

\item{decreasing}{Sort by decreasing number of passes?}

\item{by}{Report on violations per rule (default) or per record?}

\item{drop}{drop list attribute if the result has a single argument.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
A \code{data.frame} with the following columns.
\tabular{ll}{
  \code{npass} \tab Number of items passed\cr
  \code{nfail} \tab Number of items failing\cr
  \code{nNA} \tab Number of items resulting in \code{NA}\cr
  \code{rel.pass} \tab Relative number of items passed\cr
  \code{rel.fail} \tab Relative number of items failing\cr
  \code{rel.NA} \tab Relative number of items resulting in \code{NA}
}
If \code{by='rule'} the relative numbers are computed with respect to the number
of records for which the rule was evaluated. If \code{by='record'} the relative numbers
are computed with respect to the number of rules the record was tested agains. By default
the most failed validations and records with the most fails are on the top.

When \code{by='record'} and not all validation results have the same dimension structure,
a list of \code{data.frames} is returned.
}
\description{
Aggregate and sort the results of a validation.
}
\examples{

data(retailers)
retailers$id <- paste0("ret",1:nrow(retailers))
v <- validator(
    staff.costs/staff < 25
  , turnover + other.rev==total.rev)

cf <- confront(retailers,v,key="id")
a <- aggregate(cf,by='record')
head(a)

# or, get a sorted result:
s <- sort(cf, by='record')
head(s)


}
\seealso{
\itemize{
 \item{\code{\link{summary,validation-method}}}
 \item{\code{\link{aggregate,validation-method}}}
 \item{\code{\link{barplot,validation-method}}}
 \item{\code{\link{validation}}}
}
}

