% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ns.R
\name{predict.NSmodel}
\alias{predict.NSmodel}
\title{Predict Method for Nested Stacking}
\usage{
\method{predict}{NSmodel}(
  object,
  newdata,
  probability = getOption("utiml.use.probs", TRUE),
  ...,
  cores = NULL,
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{object}{Object of class '\code{NSmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{Ignored because this method does not support multi-core.}

\item{seed}{An optional integer used to set the seed.
(Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by \code{ns}.
The scores of the prediction was adapted once this method uses a correction
of labelsets to predict only classes present on training data. To more
information about this implementation see \code{\link{subset_correction}}.
}
\examples{
model <- ns(toyml, "RANDOM")
pred <- predict(model, toyml)

\donttest{
# Predict SVM bipartitions
pred <- predict(model, toyml, probability = FALSE)

# Passing a specif parameter for SVM predict algorithm
pred <- predict(model, toyml, na.action = na.fail)
}
}
\seealso{
\code{\link[=ns]{Nested Stacking (NS)}}
}
